// Effect of Loop Gain K of a Negative feedback system on Stability.
// G(s) = wn^2 / s(s+2zeta wn) , H(s) = K , T(s) = K wn^2 / ( s(s+2zeta wn) + K wn^2 )
s=%s;
t=0:0.01:10;
wn=1;zeta=1;
K=[1,2,5,10] 
for n=1:4
    T=syslin('c', K(n)*wn^2 , s*(s + 2*zeta*wn) + K(n)*wn^2 );
    Ts=csim('step',t,T);
    xset("line style",n);
    plot2d(t,Ts);   
    xgrid(3); 
end
xtitle('Effect of Loop Gain K of a - ve feedback system on Stability.','Time(sec)','C(t)');
legends(['K=1';'K=2';'K=5';'K=10';],[[1;1],[1;2],[1;3],[1;4]], opt=4);


